require( "scripts/style.lua" );

kButtonSpacing = 40;	-- Put our buttons 60 pixels apart
kButtonY = kCenter-80;	-- Three buttons means center 60 pixels above the center

StandardButtonFont = {
  standardFont,
  24,
  BlackColor
};

TitleButtonFont = {
  standardFont,
  28,
  BlackColor
};

ButtonStyleMenu = {
	parent = ButtonStyle,
	font = StandardButtonFontWhite,
};

MakeDialog
{
	-- Name the modal dialog
	name="pausemenu",
	Bitmap
	{
		image="backgrounds/dialog",
		x=kCenter,
		y=kCenter,
		
		Text
		{
			font = TitleButtonFont,
			name = "title",
			x=0,y=20,w=kMax,h=30,
			flags = kHAlignCenter + kVAlignTop,
			label = "pause_menu"
		};

		SetStyle(PauseButtonStyle),
		Button
		{
			x=kCenter,
			y=kButtonY,
			w	= 180,
			h	= 30,
			label="resume",
			close = true,	-- Just close this window
			command=
				function()
					GameResumeFromDialog();
				end
		},
		
		Button
		{
			x		= kCenter,
			y		= kButtonY + (kButtonSpacing * 1),
			w	= 180,
			h	= 30,
			label	= "restart",
			close	= true,
			command	= function()
						SendGameMessage("restart");
					  end
		},
		
		Button
		{
			x=kCenter,
			y=kButtonY + (kButtonSpacing * 2),
			w	= 180,
			h	= 30,
			label="options",
			command=
				function()
					-- Pop up an options screen
					DoModal("scripts/options.lua");
				end
		},
		
			Button
		{
			x=kCenter,
			y=kButtonY + (kButtonSpacing * 3),
			w	= 180,
			h	= 30,
			label="returntomap",
			command=
				function()                 
                    -- new by Pardo
                    result = DisplayDialog {
							"scripts/yesno.lua",
							body ="quitconfirm",
							title = "quittitle"
						};
						if (result=='yes') then
							close = true
							if (gMode == "endless") then 
								PopModal("pausemenu");
								SendGameMessage( "quittomap" );
								SwapToModal("scripts/metamap.lua");
							else
								PopModal("pausemenu");
								SendGameMessage( "quittomap" );
								SwapToModal("scripts/metamap.lua");
							end
						end
				end
		},
		
		Button
		{
			x=kCenter,
			y=kButtonY + (kButtonSpacing * 4),
			w	= 180,
			h	= 30,
			label="help",
			command=
				function()
					-- Pop up an options screen
					DoModal("scripts/help.lua");
				end
		},
		
		Button
		{
			x=kCenter,
			y=kButtonY + (kButtonSpacing * 5),
			ww	= 180,
			h	= 30,
			label="quit",
			command=
				function()
					-- Our game provides this call--it's not a Playground
					-- call.
                   -- SendGameMessage( "quit" );
                    
                    -- modified by Jorge !!
                    result = DisplayDialog {
							"scripts/yesno.lua",
							body ="quitconfirm",
							title = "quittitle"
						};
						if (result=='yes') then
							--PostMessage( CreateNamedMessage( kQuitNow, "Quit" ) );
							close = true
							--PopModal("scripts/level.lua");
							--DoModal("scripts/welcome.lua");
							--SwapToModal("scripts/welcome.lua");
							SendGameMessage( "quit" );
						end
				end
		},
	},
}

GameInPauseDialog(true, false);